/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine;

import es.eucm.eadventure.comm.AdventureApplet;
import es.eucm.eadventure.comm.manager.commManager.CommManagerLD;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.core.gui.GUIApplet;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.BorderLayout;
import java.io.InputStream;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.swing.JApplet;

public class EAdventureApplet
extends CommManagerLD {
    private static final long serialVersionUID = 1L;
    private Game eAdventure;
    private Thread gameThread;

    public void init() {
        TC.loadStrings((InputStream)EAdventureApplet.class.getResourceAsStream("/i18n/engine/en_EN.xml"));
        try {
            Codec codec = (Codec)Class.forName("net.sourceforge.jffmpeg.VideoDecoder").newInstance();
            PlugInManager.addPlugIn((String)"net.sourceforge.jffmpeg.VideoDecoder", (Format[])codec.getSupportedInputFormats(), (Format[])codec.getSupportedOutputFormats(null), (int)2);
            PlugInManager.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readParameters();
        ResourceHandler.setRestrictedMode(true);
        ResourceHandler.getInstance().setZipFile("integration.zip");
        if (!this.windowed) {
            this.setLayout(new BorderLayout());
            GUI.setGUIType(1);
            GUIApplet.setApplet((JApplet)((Object)this));
        }
        Game.create();
        this.eAdventure = Game.getInstance();
        this.eAdventure.setAdventureName("integration");
        this.eAdventure.setComm((AdventureApplet)this);
    }

    public void start() {
        this.connect(null);
        this.gameThread = new Thread(this.eAdventure);
        this.gameThread.start();
    }

    public void stop() {
        System.out.println("Closing...");
        this.eAdventure.setGameOver();
        try {
            System.out.println("Trying to join...");
            this.gameThread.join();
            System.out.println("...join successful.");
            Game.delete();
            ResourceHandler.delete();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.destroy();
    }
}

