/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class ProgressInputStream
extends FilterInputStream {
    private int nread;
    private int size;
    private boolean started;
    private Vector listeners = new Vector();
    private String name;
    protected static final int MAX = 0;
    protected static final int VALUE = 1;
    protected static final int START = 2;
    protected static final int END = 3;

    public ProgressInputStream(InputStream inputStream, int n, String string) {
        super(inputStream);
        this.name = string;
        this.started = false;
        this.nread = 0;
        this.size = n;
        if (this.size <= 0) {
            try {
                this.size = inputStream.available();
            }
            catch (IOException iOException) {
                this.size = 0;
            }
        }
    }

    public void addProgressInputStreamListener(ProgressInputStreamListener progressInputStreamListener) {
        if (!this.listeners.contains(progressInputStreamListener)) {
            this.listeners.add(progressInputStreamListener);
        }
    }

    private void start() {
        if (!this.started) {
            this.notifyListeners(0, this.size);
            this.notifyListeners(1, 0);
            this.notifyListeners(2, 0);
            this.started = true;
        }
    }

    public int read() throws IOException {
        int n;
        if (!this.started) {
            this.start();
        }
        if ((n = this.in.read()) >= 0) {
            this.notifyListeners(1, this.size);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (!this.started) {
            this.start();
        }
        if ((n = this.in.read(byArray)) > 0) {
            this.notifyListeners(1, this.nread += n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (!this.started) {
            this.start();
        }
        if ((n3 = this.in.read(byArray, n, n2)) > 0) {
            this.notifyListeners(1, this.nread += n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2;
        if (!this.started) {
            this.start();
        }
        if ((l2 = this.in.skip(l)) > 0L) {
            this.nread = (int)((long)this.nread + l2);
            this.notifyListeners(1, this.nread);
        }
        return l2;
    }

    public void close() throws IOException {
        if (!this.started) {
            this.start();
        }
        this.in.close();
        this.notifyListeners(3, 0);
    }

    public synchronized void reset() throws IOException {
        if (!this.started) {
            this.start();
        }
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.notifyListeners(1, this.nread);
    }

    private void notifyListeners(int n, int n2) {
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            ProgressInputStreamListener progressInputStreamListener = (ProgressInputStreamListener)iterator.next();
            switch (n) {
                case 0: {
                    progressInputStreamListener.setProgressMax(n2);
                    break;
                }
                case 1: {
                    progressInputStreamListener.setProgressValue(n2);
                    break;
                }
                case 2: {
                    progressInputStreamListener.startProgress(this.name);
                    break;
                }
                case 3: {
                    progressInputStreamListener.endProgress();
                    break;
                }
            }
        }
    }

    public static interface ProgressInputStreamListener {
        public void setProgressMax(int var1);

        public void setProgressValue(int var1);

        public void startProgress(String var1);

        public void endProgress();
    }
}

