/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class LFUtil {
    public static final String LOOK_AND_FEEL = "lookAndFeel";
    public static final String DEFAULT = "default";
    public static final String SYSTEM = "system";
    public static final String METAL = "metal";
    public static final String MOTIF = "motif";
    public static final String WINDOWS = "windows";
    public static final String[] VALUES = new String[]{"default", "system", "metal", "motif"};

    public static void setLookAndFeel(String string, Component component) {
        if (string != null) {
            try {
                if (string.equals(DEFAULT)) {
                    LFUtil.setLookAndFeel(null, UIManager.getCrossPlatformLookAndFeelClassName(), component);
                } else if (string.equals(SYSTEM)) {
                    LFUtil.setLookAndFeel(null, UIManager.getSystemLookAndFeelClassName(), component);
                } else if (string.equals(METAL)) {
                    LFUtil.setLookAndFeel("javax.swing.plaf", "metal.MetalLookAndFeel", component);
                } else if (string.equals(MOTIF)) {
                    LFUtil.setLookAndFeel("com.sun.java.swing.plaf", "motif.MotifLookAndFeel", component);
                } else if (string.equals(WINDOWS)) {
                    LFUtil.setLookAndFeel("com.sun.java.swing.plaf", "windows.WindowsLookAndFeel", component);
                }
            }
            catch (Exception exception) {
                System.err.println("unable to set lookAndFeel to: \"" + string + "\"\n" + exception);
            }
        }
    }

    private static void setLookAndFeel(String string, String string2, Component component) throws Exception {
        String string3 = string != null && string.length() > 0 ? string + "." + string2 : string2;
        UIManager.setLookAndFeel(string3);
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    public static Color getSysColor(String string, Color color) {
        Color color2 = UIManager.getColor(string);
        return color2 == null ? color : color2;
    }

    public static Color getColor(String string, Color color) {
        Color color2 = color;
        Object object = UIManager.get(string);
        if (object != null && object instanceof Color) {
            color2 = (Color)object;
        }
        return color2;
    }

    public static Font getFont(String string, Font font) {
        Font font2 = font;
        Object object = UIManager.get(string);
        if (object != null && object instanceof Font) {
            font2 = (Font)object;
        }
        return font2;
    }
}

