/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class FileChooserForFiles
extends JFileChooser {
    static Class WindowsFileChooserUIClass;
    static Method getFileNameMethod;

    public FileChooserForFiles() {
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(File file) {
        super(file);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(FileSystemView fileSystemView) {
        super(fileSystemView);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(String string) {
        super(string);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
        this.setFileSelectionMode(0);
    }

    public void setCurrentDirectory(File file) {
        String string = this.getCurrentFileName();
        super.setCurrentDirectory(file);
        if (string != null && string.indexOf(34) == -1 && this.getCurrentFileName() == null) {
            this.setSelectedFile(new File(file, string));
        }
    }

    private final String getCurrentFileName() {
        FileChooserUI fileChooserUI = this.getUI();
        String string = null;
        if (fileChooserUI instanceof MetalFileChooserUI) {
            string = ((MetalFileChooserUI)fileChooserUI).getFileName();
        } else if (WindowsFileChooserUIClass != null && WindowsFileChooserUIClass.isInstance(fileChooserUI) && getFileNameMethod != null) {
            try {
                string = (String)getFileNameMethod.invoke((Object)fileChooserUI, (Object[])null);
            }
            catch (Exception exception) {
                string = null;
            }
        } else {
            string = null;
        }
        return string == null || string.trim().length() == 0 ? null : string;
    }

    public void directSetSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    public void setSelectedFile(File file) {
        if (file != null && (file.isDirectory() && this.isDirectorySelectionEnabled() || !file.isDirectory() && this.isFileSelectionEnabled())) {
            super.setSelectedFile(file);
        }
    }

    static {
        try {
            WindowsFileChooserUIClass = Class.forName("com.sun.java.swing.plaf.windows.WindowsFileChooserUI");
            if (WindowsFileChooserUIClass != null) {
                getFileNameMethod = WindowsFileChooserUIClass.getMethod("getFileName", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

