/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.mixer.TLine;

public abstract class TMixer
extends TLine
implements Mixer {
    private static Line.Info[] EMPTY_LINE_INFO_ARRAY = new Line.Info[0];
    private static Line[] EMPTY_LINE_ARRAY = new Line[0];
    private Mixer.Info m_mixerInfo;
    private Collection m_supportedSourceFormats;
    private Collection m_supportedTargetFormats;
    private Collection m_supportedSourceLineInfos;
    private Collection m_supportedTargetLineInfos;
    private Set m_openSourceDataLines;
    private Set m_openTargetDataLines;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$Port;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    protected TMixer(Mixer.Info info, Line.Info info2) {
        this(info, info2, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    }

    protected TMixer(Mixer.Info info, Line.Info info2, Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        super(null, info2);
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.<init>(): begin");
        }
        this.m_mixerInfo = info;
        this.setSupportInformation(collection, collection2, collection3, collection4);
        this.m_openSourceDataLines = new ArraySet();
        this.m_openTargetDataLines = new ArraySet();
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.<init>(): end");
        }
    }

    protected void setSupportInformation(Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.setSupportInformation(): begin");
        }
        this.m_supportedSourceFormats = collection;
        this.m_supportedTargetFormats = collection2;
        this.m_supportedSourceLineInfos = collection3;
        this.m_supportedTargetLineInfos = collection4;
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.setSupportInformation(): end");
        }
    }

    public Mixer.Info getMixerInfo() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getMixerInfo(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getMixerInfo(): end");
        }
        return this.m_mixerInfo;
    }

    public Line.Info[] getSourceLineInfo() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLineInfo(): begin");
        }
        Line.Info[] infoArray = this.m_supportedSourceLineInfos.toArray(EMPTY_LINE_INFO_ARRAY);
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLineInfo(): end");
        }
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLineInfo(): begin");
        }
        Line.Info[] infoArray = this.m_supportedTargetLineInfos.toArray(EMPTY_LINE_INFO_ARRAY);
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLineInfo(): end");
        }
        return infoArray;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLineInfo(Line.Info): info to test: " + info);
        }
        return EMPTY_LINE_INFO_ARRAY;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLineInfo(Line.Info): info to test: " + info);
        }
        return EMPTY_LINE_INFO_ARRAY;
    }

    public boolean isLineSupported(Line.Info info) {
        Class<?> clazz;
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.isLineSupported(): info to test: " + info);
        }
        if ((clazz = info.getLineClass()).equals(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = TMixer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine)) {
            return TMixer.isLineSupportedImpl(info, this.m_supportedSourceLineInfos);
        }
        if (clazz.equals(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = TMixer.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine)) {
            return TMixer.isLineSupportedImpl(info, this.m_supportedTargetLineInfos);
        }
        if (clazz.equals(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = TMixer.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port)) {
            return TMixer.isLineSupportedImpl(info, this.m_supportedSourceLineInfos) || TMixer.isLineSupportedImpl(info, this.m_supportedTargetLineInfos);
        }
        return false;
    }

    private static boolean isLineSupportedImpl(Line.Info info, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Line.Info info2 = (Line.Info)iterator.next();
            if (!info2.matches(info)) continue;
            return true;
        }
        return false;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getLine(): begin");
        }
        Class<?> clazz = info.getLineClass();
        DataLine.Info info2 = null;
        Port.Info info3 = null;
        AudioFormat[] audioFormatArray = null;
        if (info instanceof DataLine.Info) {
            info2 = (DataLine.Info)info;
            audioFormatArray = info2.getFormats();
        } else if (info instanceof Port.Info) {
            info3 = (Port.Info)info;
        }
        AudioFormat audioFormat = null;
        Line line = null;
        if (clazz == (class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = TMixer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine)) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: SourceDataLine");
            }
            if (info2 == null) {
                throw new IllegalArgumentException("need DataLine.Info for SourceDataLine");
            }
            audioFormat = this.getSupportedSourceFormat(audioFormatArray);
            line = this.getSourceDataLine(audioFormat, info2.getMaxBufferSize());
        } else if (clazz == (class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = TMixer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip)) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: Clip");
            }
            if (info2 == null) {
                throw new IllegalArgumentException("need DataLine.Info for Clip");
            }
            audioFormat = this.getSupportedSourceFormat(audioFormatArray);
            line = this.getClip(audioFormat);
        } else if (clazz == (class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = TMixer.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine)) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: TargetDataLine");
            }
            if (info2 == null) {
                throw new IllegalArgumentException("need DataLine.Info for TargetDataLine");
            }
            audioFormat = this.getSupportedTargetFormat(audioFormatArray);
            line = this.getTargetDataLine(audioFormat, info2.getMaxBufferSize());
        } else if (clazz == (class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = TMixer.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port)) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: TargetDataLine");
            }
            if (info3 == null) {
                throw new IllegalArgumentException("need Port.Info for Port");
            }
            line = this.getPort(info3);
        } else {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): unknown line type, will throw exception");
            }
            throw new LineUnavailableException("unknown line class: " + clazz);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getLine(): end");
        }
        return line;
    }

    protected SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceDataLine(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support SourceDataLines");
    }

    protected Clip getClip(AudioFormat audioFormat) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getClip(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support Clips");
    }

    protected TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetDataLine(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support TargetDataLines");
    }

    protected Port getPort(Port.Info info) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetDataLine(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support Ports");
    }

    private AudioFormat getSupportedSourceFormat(AudioFormat[] audioFormatArray) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedSourceFormat(): begin");
        }
        AudioFormat audioFormat = null;
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getSupportedSourceFormat(): checking " + audioFormatArray[n] + "...");
            }
            if (this.isSourceFormatSupported(audioFormatArray[n])) {
                if (TDebug.TraceMixer) {
                    TDebug.out("TMixer.getSupportedSourceFormat(): ...supported");
                }
                audioFormat = audioFormatArray[n];
                break;
            }
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getSupportedSourceFormat(): ...no luck");
            }
            ++n;
        }
        if (audioFormat == null) {
            throw new IllegalArgumentException("no line matchine one of the passed formats");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedSourceFormat(): end");
        }
        return audioFormat;
    }

    private AudioFormat getSupportedTargetFormat(AudioFormat[] audioFormatArray) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedTargetFormat(): begin");
        }
        AudioFormat audioFormat = null;
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getSupportedTargetFormat(): checking " + audioFormatArray[n] + " ...");
            }
            if (this.isTargetFormatSupported(audioFormatArray[n])) {
                if (TDebug.TraceMixer) {
                    TDebug.out("TMixer.getSupportedTargetFormat(): ...supported");
                }
                audioFormat = audioFormatArray[n];
                break;
            }
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getSupportedTargetFormat(): ...no luck");
            }
            ++n;
        }
        if (audioFormat == null) {
            throw new IllegalArgumentException("no line matchine one of the passed formats");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedTargetFormat(): end");
        }
        return audioFormat;
    }

    public Line[] getSourceLines() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLines(): called");
        }
        return this.m_openSourceDataLines.toArray(EMPTY_LINE_ARRAY);
    }

    public Line[] getTargetLines() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLines(): called");
        }
        return this.m_openTargetDataLines.toArray(EMPTY_LINE_ARRAY);
    }

    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("synchronization not supported");
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("synchronization not supported");
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    protected boolean isSourceFormatSupported(AudioFormat audioFormat) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.isSourceFormatSupported(): format to test: " + audioFormat);
        }
        Iterator iterator = this.m_supportedSourceFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTargetFormatSupported(AudioFormat audioFormat) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.isTargetFormatSupported(): format to test: " + audioFormat);
        }
        Iterator iterator = this.m_supportedTargetFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            return true;
        }
        return false;
    }

    void registerOpenLine(Line line) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.registerOpenLine(): line to register: " + line);
        }
        if (line instanceof SourceDataLine) {
            Set set = this.m_openSourceDataLines;
            synchronized (set) {
                this.m_openSourceDataLines.add(line);
            }
        }
        if (line instanceof TargetDataLine) {
            Set set = this.m_openSourceDataLines;
            synchronized (set) {
                this.m_openTargetDataLines.add(line);
            }
        }
    }

    void unregisterOpenLine(Line line) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.unregisterOpenLine(): line to unregister: " + line);
        }
        if (line instanceof SourceDataLine) {
            Set set = this.m_openSourceDataLines;
            synchronized (set) {
                this.m_openSourceDataLines.remove(line);
            }
        }
        if (line instanceof TargetDataLine) {
            Set set = this.m_openTargetDataLines;
            synchronized (set) {
                this.m_openTargetDataLines.remove(line);
            }
        }
    }

    public abstract int getMaxLines(Line.Info var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

