/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.lame;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.lowlevel.lame.Lame;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormatSet;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public class Mp3LameFormatConversionProvider
extends TSimpleFormatConversionProvider {
    private static final int ALL = -1;
    private static final int MPEG_BITS_PER_SAMPLE = -1;
    private static final int MPEG_FRAME_RATE = -1;
    private static final int MPEG_FRAME_SIZE = -1;
    public static final AudioFormat.Encoding MPEG1L3 = Encodings.getEncoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L3 = Encodings.getEncoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = Encodings.getEncoding("MPEG2DOT5L3");
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 8000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 8000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 11025.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 11025.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 12000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 12000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 16000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 16000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 22050.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 22050.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 24000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 24000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, true)};
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};

    public Mp3LameFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
        if (!Lame.isLibAvailable()) {
            this.disable();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("******* Error initializing LAME mp3 encoder: " + Lame.getLinkError());
            }
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (this.isConversionSupported(audioFormat, audioInputStream.getFormat())) {
            return new EncodedMpegAudioInputStream(this.getDefaultTargetFormat(audioFormat, audioInputStream.getFormat(), false), audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">MP3Lame getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out("from: " + audioFormat);
            TDebug.out("to  : " + encoding);
        }
        if (this.isConversionSupported(encoding, audioFormat)) {
            AudioFormatSet audioFormatSet = new AudioFormatSet();
            Iterator iterator = this.getCollectionTargetFormats().iterator();
            while (iterator.hasNext()) {
                AudioFormat audioFormat2 = (AudioFormat)iterator.next();
                if (!TSimpleFormatConversionProvider.doMatch(audioFormat2.getSampleRate(), audioFormat.getSampleRate()) || !audioFormat2.getEncoding().equals(encoding) || !TSimpleFormatConversionProvider.doMatch(audioFormat2.getChannels(), audioFormat.getChannels())) continue;
                audioFormat2 = this.getDefaultTargetFormat(audioFormat2, audioFormat, true);
                audioFormatSet.add(audioFormat2);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<found " + audioFormatSet.size() + " matching formats.");
            }
            return audioFormatSet.toAudioFormatArray();
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat audioFormat, AudioFormat audioFormat2, boolean bl) {
        float f = audioFormat.getSampleRate();
        if (f == -1.0f) {
            f = audioFormat2.getSampleRate();
        }
        if (!bl && f == -1.0f || f != -1.0f && audioFormat2.getSampleRate() != -1.0f && f != audioFormat2.getSampleRate()) {
            throw new IllegalArgumentException("Illegal sample rate (" + f + ") !");
        }
        int n = audioFormat.getChannels();
        if (n == -1) {
            n = audioFormat2.getChannels();
        }
        if (!bl && n == -1 || n != -1 && audioFormat2.getChannels() != -1 && n != audioFormat2.getChannels()) {
            throw new IllegalArgumentException("Illegal number of channels (" + n + ") !");
        }
        AudioFormat audioFormat3 = new AudioFormat(audioFormat.getEncoding(), f, -1, n, this.getFrameSize(audioFormat.getEncoding(), f, -1, n, -1.0f, false, 0), -1.0f, false);
        return audioFormat3;
    }

    protected int getFrameSize(AudioFormat.Encoding encoding, float f, int n, int n2, float f2, boolean bl, int n3) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            return super.getFrameSize(encoding, f, n, n2, f2, bl, n3);
        }
        return -1;
    }

    public static class EncodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream pcmStream;
        private Lame encoder;
        private byte[] pcmBuffer;
        private byte[] encodedBuffer;

        public EncodedMpegAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioFormat, -1L);
            this.pcmStream = audioInputStream;
            this.encoder = new Lame(audioInputStream.getFormat());
            this.pcmBuffer = new byte[this.encoder.getPCMBufferSize()];
            this.encodedBuffer = new byte[this.encoder.getMP3BufferSize()];
        }

        public void execute() {
            block10: {
                try {
                    if (this.encoder == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("mp3 lame encoder is null (already at end of stream)");
                        }
                        this.getCircularBuffer().close();
                        return;
                    }
                    int n = 0;
                    byte[] byArray = null;
                    while (n == 0 && this.encoder != null) {
                        int n2 = this.pcmStream.read(this.pcmBuffer);
                        if (n2 > 0) {
                            n = this.encoder.encodeBuffer(this.pcmBuffer, 0, n2, this.encodedBuffer);
                            byArray = this.encodedBuffer;
                            continue;
                        }
                        byArray = this.encodedBuffer.length > this.pcmBuffer.length ? this.encodedBuffer : this.pcmBuffer;
                        n = this.encoder.encodeFinish(byArray);
                        this.encoder.close();
                        this.encoder = null;
                    }
                    if (n > 0) {
                        this.getCircularBuffer().write(byArray, 0, n);
                    }
                    if (this.encoder == null) {
                        this.getCircularBuffer().close();
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (TDebug.TraceAudioConverter || TDebug.TraceAllExceptions) {
                        TDebug.out(arrayIndexOutOfBoundsException);
                    }
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceAudioConverter && !TDebug.TraceAllExceptions) break block10;
                    TDebug.out(iOException);
                }
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.pcmStream.close();
            if (this.encoder != null) {
                this.encoder.encodeFinish(null);
                this.encoder.close();
                this.encoder = null;
            }
        }
    }
}

