/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.javalayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TMatrixFormatConversionProvider;

public class MpegFormatConversionProvider
extends TMatrixFormatConversionProvider {
    public static final AudioFormat.Encoding MPEG1L1 = Encodings.getEncoding("MPEG1L1");
    public static final AudioFormat.Encoding MPEG1L2 = Encodings.getEncoding("MPEG1L2");
    public static final AudioFormat.Encoding MPEG1L3 = Encodings.getEncoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L1 = Encodings.getEncoding("MPEG2L1");
    public static final AudioFormat.Encoding MPEG2L2 = Encodings.getEncoding("MPEG2L2");
    public static final AudioFormat.Encoding MPEG2L3 = Encodings.getEncoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L1 = Encodings.getEncoding("MPEG2DOT5L1");
    public static final AudioFormat.Encoding MPEG2DOT5L2 = Encodings.getEncoding("MPEG2DOT5L2");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = Encodings.getEncoding("MPEG2DOT5L3");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MPEG1L1, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};
    private static final boolean t = true;
    private static final boolean f = false;
    private static final boolean[][] CONVERSIONS = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS), CONVERSIONS);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.<init>(): begin");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.<init>(): end");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioFormat audioFormat2;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
            TDebug.out("trying to convert");
            TDebug.out("\tfrom: " + audioInputStream.getFormat());
            TDebug.out("\tto: " + audioFormat);
        }
        if ((audioFormat2 = this.getMatchingFormat(audioFormat, audioInputStream.getFormat())) != null) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tisConversionSupported() accepted it; now setting up the conversion");
            }
            audioFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(audioFormat, audioFormat2);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tcompleted target format (1. stage): " + audioFormat);
            }
            audioFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(audioFormat, audioInputStream.getFormat());
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tcompleted target format (2. stage): " + audioFormat);
            }
            return new DecodedMpegAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    private static AudioFormat setUnspecifiedFieldsFromProto(AudioFormat audioFormat, AudioFormat audioFormat2) {
        AudioFormat audioFormat3 = new AudioFormat(audioFormat.getEncoding(), MpegFormatConversionProvider.getSpecificValue(audioFormat.getSampleRate(), audioFormat2.getSampleRate()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getSampleSizeInBits(), audioFormat2.getSampleSizeInBits()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getChannels(), audioFormat2.getChannels()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getFrameSize(), audioFormat2.getFrameSize()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getFrameRate(), audioFormat2.getFrameRate()), audioFormat.isBigEndian());
        return audioFormat3;
    }

    private static float getSpecificValue(float f, float f2) {
        return f == -1.0f ? f2 : f;
    }

    private static int getSpecificValue(int n, int n2) {
        return n == -1 ? n2 : n;
    }

    public static class DecodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream m_encodedStream;
        private Bitstream m_bitstream;
        private Decoder m_decoder;
        private DMAISObuffer m_oBuffer;

        public DecodedMpegAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioFormat, -1L);
            this.m_encodedStream = audioInputStream;
            this.m_bitstream = new Bitstream(audioInputStream);
            this.m_decoder = new Decoder(null);
            this.m_oBuffer = new DMAISObuffer(audioFormat.getChannels());
            this.m_decoder.setOutputBuffer(this.m_oBuffer);
        }

        public void execute() {
            block6: {
                try {
                    Header header = this.m_bitstream.readFrame();
                    if (header == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("header is null (end of mpeg stream)");
                        }
                        this.getCircularBuffer().close();
                        return;
                    }
                    Obuffer obuffer = this.m_decoder.decodeFrame(header, this.m_bitstream);
                    this.m_bitstream.closeFrame();
                    this.getCircularBuffer().write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                    this.m_oBuffer.reset();
                }
                catch (BitstreamException bitstreamException) {
                    if (TDebug.TraceAudioConverter || TDebug.TraceAllExceptions) {
                        TDebug.out(bitstreamException);
                    }
                }
                catch (DecoderException decoderException) {
                    if (!TDebug.TraceAudioConverter && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(decoderException);
                }
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }

        private class DMAISObuffer
        extends Obuffer {
            private int m_nChannels;
            private byte[] m_abBuffer;
            private int[] m_anBufferPointers;
            private boolean m_bIsBigEndian;

            public DMAISObuffer(int n) {
                this.m_nChannels = n;
                this.m_abBuffer = new byte[2304 * n];
                this.m_anBufferPointers = new int[n];
                this.reset();
                this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
            }

            public void append(int n, short s) {
                TConversionTool.shortToBytes16(s, this.m_abBuffer, this.m_anBufferPointers[n], this.m_bIsBigEndian);
                int n2 = n;
                this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
            }

            public void set_stop_flag() {
            }

            public void close() {
            }

            public void write_buffer(int n) {
            }

            public void clear_buffer() {
            }

            public byte[] getBuffer() {
                return this.m_abBuffer;
            }

            public int getCurrentBufferSize() {
                return this.m_anBufferPointers[0];
            }

            public void reset() {
                int n = 0;
                while (n < this.m_nChannels) {
                    this.m_anBufferPointers[n] = n * 2;
                    ++n;
                }
            }
        }
    }
}

