/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.mpeg.sampled.file.tag;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;
import javazoom.spi.mpeg.sampled.file.tag.IcyTag;
import javazoom.spi.mpeg.sampled.file.tag.MP3MetadataParser;
import javazoom.spi.mpeg.sampled.file.tag.MP3Tag;
import javazoom.spi.mpeg.sampled.file.tag.MP3TagParseSupport;
import javazoom.spi.mpeg.sampled.file.tag.TagParseListener;

public class IcyInputStream
extends BufferedInputStream
implements MP3MetadataParser {
    public static boolean DEBUG = false;
    MP3TagParseSupport tagParseSupport;
    protected static final String INLINE_TAG_SEPARATORS = ";\u0000";
    HashMap tags;
    protected byte[] crlfBuffer = new byte[1024];
    protected int metaint = -1;
    protected int bytesUntilNextMetadata = -1;

    public IcyInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.tags = new HashMap();
        this.tagParseSupport = new MP3TagParseSupport();
        this.readInitialHeaders();
        IcyTag icyTag = (IcyTag)this.getTag("icy-metaint");
        if (DEBUG) {
            System.out.println("METATAG:" + icyTag);
        }
        if (icyTag != null) {
            String string = icyTag.getValueAsString();
            try {
                this.metaint = Integer.parseInt(string.trim());
                if (DEBUG) {
                    System.out.println("METAINT:" + this.metaint);
                }
                this.bytesUntilNextMetadata = this.metaint;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IcyInputStream(InputStream inputStream, String string) throws IOException {
        super(inputStream);
        this.tags = new HashMap();
        this.tagParseSupport = new MP3TagParseSupport();
        try {
            this.metaint = Integer.parseInt(string.trim());
            if (DEBUG) {
                System.out.println("METAINT:" + this.metaint);
            }
            this.bytesUntilNextMetadata = this.metaint;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void readInitialHeaders() throws IOException {
        String string = null;
        while (!(string = this.readCRLFLine()).equals("")) {
            int n = string.indexOf(58);
            if (n == -1) continue;
            IcyTag icyTag = new IcyTag(string.substring(0, n), string.substring(n + 1));
            this.addTag(icyTag);
        }
    }

    protected String readCRLFLine() throws IOException {
        int n = 0;
        while (n < this.crlfBuffer.length) {
            byte by = (byte)this.read();
            if (by == 13) {
                byte by2 = (byte)this.read();
                ++n;
                if (by2 == 10) break;
                this.crlfBuffer[n - 1] = by;
                this.crlfBuffer[n] = by2;
            } else {
                this.crlfBuffer[n] = by;
            }
            ++n;
        }
        return new String(this.crlfBuffer, 0, n - 1);
    }

    public int read() throws IOException {
        if (this.bytesUntilNextMetadata > 0) {
            --this.bytesUntilNextMetadata;
            return super.read();
        }
        if (this.bytesUntilNextMetadata == 0) {
            this.readMetadata();
            this.bytesUntilNextMetadata = this.metaint - 1;
            return super.read();
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesUntilNextMetadata > 0) {
            int n3 = Math.min(n2, this.bytesUntilNextMetadata);
            int n4 = super.read(byArray, n, n3);
            this.bytesUntilNextMetadata -= n4;
            return n4;
        }
        if (this.bytesUntilNextMetadata == 0) {
            this.readMetadata();
            this.bytesUntilNextMetadata = this.metaint;
            int n5 = Math.min(n2, this.bytesUntilNextMetadata);
            int n6 = super.read(byArray, n, n5);
            this.bytesUntilNextMetadata -= n6;
            return n6;
        }
        return super.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    protected void readMetadata() throws IOException {
        int n;
        int n2 = super.read();
        if (DEBUG) {
            System.out.println("BLOCKCOUNT:" + n2);
        }
        if ((n = n2 * 16) < 0) {
            return;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0) {
            int n4 = super.read(byArray, n3, n);
            n3 += n4;
            n -= n4;
        }
        if (n2 > 0) {
            this.parseInlineIcyTags(byArray);
        }
    }

    protected void parseInlineIcyTags(byte[] byArray) {
        String string = new String(byArray);
        if (DEBUG) {
            System.out.println("BLOCKSTR:" + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, INLINE_TAG_SEPARATORS);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            int n2 = string2.charAt(n + 1) == '\'' ? n + 2 : n + 1;
            int n3 = string2.charAt(string2.length() - 1) == '\'' ? string2.length() - 1 : string2.length();
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n2, n3);
            IcyTag icyTag = new IcyTag(string3, string4);
            this.addTag(icyTag);
        }
    }

    protected void addTag(IcyTag icyTag) {
        this.tags.put(icyTag.getName(), icyTag);
        this.tagParseSupport.fireTagParsed(this, icyTag);
    }

    public MP3Tag getTag(String string) {
        return (MP3Tag)this.tags.get(string);
    }

    public MP3Tag[] getTags() {
        return this.tags.values().toArray(new MP3Tag[0]);
    }

    public HashMap getTagHash() {
        return this.tags;
    }

    public void addTagParseListener(TagParseListener tagParseListener) {
        this.tagParseSupport.addTagParseListener(tagParseListener);
    }

    public void removeTagParseListener(TagParseListener tagParseListener) {
        this.tagParseSupport.removeTagParseListener(tagParseListener);
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[200];
        if (stringArray.length != 1) {
            return;
        }
        try {
            URL uRL = new URL(stringArray[0]);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("Icy-Metadata", "1");
            IcyInputStream icyInputStream = new IcyInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            while (icyInputStream.available() > -1) {
                icyInputStream.read(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

