var Silva = Silva || {};
Silva.DShopX = Silva.DShopX || {};
Silva.DShopX.version = 1.11;

var Imported = Imported || {};
Imported.SilvaDialogueShopX = true;

/*:
 * @plugindesc v1.11 Adds a picture window to Mjshi's NPCDialogueShop.
 * @author Silva
 *
 * @param Icon Window
 * @type struct<Window>
 * @default {"x":"300","y":"300","width":"128","height":"128"}
 *
 * @param Toggle Visibility
 * @type boolean
 * @desc ON = Window will only show when buy/sell window are active.
 * OFF = Window will always be visible.
 *
 * @help
 * <---------------------------------------------------------------------------->
 *
 * This plugin adds a picture window to Mjshi's NPCDialogueShop to display item
 * icons / images.
 *
 * As the default Mjshi's shop layout is already populated the new window will
 * appear above other windows and may cause visual abnormalities - this is to be
 * expected. Once you reposition the windows so that none are overlapping these
 * issues should disappear.
 *
 * Use the plugin parameters to set the location of the picture window.
 *
 * Displaying images requires YEP_ItemCore and YEP_X_ItemPictureImg. Use the
 * notetags as described in YEP_X_ItemPictureImg to use images instead of icons.
 *
 * Pictures drawn will be resized to fill the window while maintaining their
 * original aspect ratio.
 *
 * <---------------------------------------------------------------------------->
 *
 * Version History
 *
 * 1.11 - Added parameter to toggle icon window visibility.
 *
 * 1.10 - Added support for icons.
 *
 * 1.00 - Plugin released.
 */

/*~struct~Window:
*
* @param x
* @type number
* @default 0
*
* @param y
* @type number
* @default 0
*
* @param width
* @type number
* @default 72
*
* @param height
* @type number
* @default 72
*/

Silva.Parameters = PluginManager.parameters('SilvaDialogueShopX');
Silva.Param = Silva.Param || {};
Silva.Param.DShopIconWindow = JSON.parse(Silva.Parameters['Icon Window']);
Silva.Param.DShopToggle = Silva.Parameters['Toggle Visibility'].trim() == 'true';

(function() {

	//Scene_Shop

	Silva.DShopX.Scene_Shop_create = Scene_Shop.prototype.create;
	Scene_Shop.prototype.create = function() {
		Silva.DShopX.Scene_Shop_create.call(this);
		this.createIconWindow();
	};

	Scene_Shop.prototype.createIconWindow = function() {
		this._iconWindow = new Window_ShopIcon();
		this.addWindow(this._iconWindow);
		this._buyWindow._iconWindow = this._iconWindow;
		this._sellWindow._iconWindow = this._iconWindow;
	};

	Silva.DShopX.Scene_Shop_commandBuy = Scene_Shop.prototype.commandBuy;
	Scene_Shop.prototype.commandBuy = function() {
    	Silva.DShopX.Scene_Shop_commandBuy.call(this);
    	if (Silva.Param.DShopToggle) {
    		this._iconWindow.show()
    	}
    };

    Silva.DShopX.Scene_Shop_onCategoryOk = Scene_Shop.prototype.onCategoryOk;
	Scene_Shop.prototype.onCategoryOk = function() {
    	Silva.DShopX.Scene_Shop_onCategoryOk.call(this);
    	if (Silva.Param.DShopToggle) {
    		this._iconWindow.show()
    	}
    };

	Silva.DShopX.Scene_Shop_onBuyCancel = Scene_Shop.prototype.onBuyCancel;
	Scene_Shop.prototype.onBuyCancel = function() {
		Silva.DShopX.Scene_Shop_onBuyCancel.call(this);
    	this._iconWindow.setItem(null);
    	if (Silva.Param.DShopToggle) {
    		this._iconWindow.hide()
    	}
    };

    Silva.DShopX.Scene_Shop_onSellCancel = Scene_Shop.prototype.onSellCancel;
    Scene_Shop.prototype.onSellCancel = function() {
    	Silva.DShopX.Scene_Shop_onSellCancel.call(this);
    	this._iconWindow.setItem(null);
    	if (Silva.Param.DShopToggle) {
    		this._iconWindow.hide()
    	}
    }

	//Window_ShopBuy

	Silva.DShopX.Window_ShopBuy_updateHelp = Window_ShopBuy.prototype.updateHelp;
	Window_ShopBuy.prototype.updateHelp = function() {
		Silva.DShopX.Window_ShopBuy_updateHelp.call(this);
		if (this._iconWindow) {
			this._iconWindow.setItem(this.item());
		}
	};

	//Window_ShopSell

	Silva.DShopX.Window_ShopSell_updateHelp = Window_ShopSell.prototype.updateHelp;
	Window_ShopSell.prototype.updateHelp = function() {
		Silva.DShopX.Window_ShopSell_updateHelp.call(this);
		if (this._iconWindow) {
			this._iconWindow.setItem(this.item());
		}
	};

	//Window_ShopIcon

	function Window_ShopIcon() {
		this.initialize.apply(this, arguments);
	};

	Window_ShopIcon.prototype = Object.create(Window_Base.prototype);
	Window_ShopIcon.prototype.constructor = Window_ShopIcon;

	Window_ShopIcon.prototype.initialize = function() {
		var dimensions = Silva.Param.DShopIconWindow;
		var x = dimensions.x;
		var y = dimensions.y;
		var width = dimensions.width;
		var height = dimensions.width;
		Window_Base.prototype.initialize.call(this, x, y, width, height);
		if (Silva.Param.DShopToggle) {
			this.hide();
		}
		this.refresh();
	};

	Window_ShopIcon.prototype.refresh = function() {
		this.contents.clear();
		if (this._item) {
			this.updatePicture();
		}
	};

	Window_ShopIcon.prototype.setItem = function(item) {
		if (this._item === item) return;
		this._item = item;
		this.refresh();
	};

	Window_ShopIcon.prototype.pictureWidth = function() {
		return this._width - this.standardPadding() * 2;
	};

	Window_ShopIcon.prototype.pictureHeight = function() {
		return this._height - this.standardPadding() * 2;
	};

	Window_ShopIcon.prototype.pictureRate = function(w, h) {
		var widthRate = this.pictureWidth()/w;
		var heightRate = this.pictureHeight()/h;
		return Math.min(widthRate, heightRate);
	};

	Window_ShopIcon.prototype.updatePicture = function() {
		if (Imported.YEP_ItemCore && Imported.YEP_X_ItemPictureImg && ItemManager.getItemPictureImageFilename(this._item)) {
			this.preparePicture();
		} else {
			this.drawIcon();
		}
	};

	Window_ShopIcon.prototype.preparePicture = function() {
		var picture = ItemManager.getItemPictureImage(this._item);
		if (picture.width <= 0) {
			return setTimeout(this.preparePicture.bind(this), 100);
		} else {
		this.drawPicture(picture);
		}
	};

	Window_ShopIcon.prototype.drawPicture = function(picture) {
		var pw = picture.width;
		var ph = picture.height;
		var rate = this.pictureRate(pw, ph)
		var dw = pw * rate;
		var dh = ph * rate;
		var dx = this.pictureWidth()/2 - dw/2;
		var dy = this.pictureHeight()/2 - dh/2;
		this.contents.blt(picture, 0, 0, pw, ph, dx, dy, dw, dh);
	};

	Window_ShopIcon.prototype.drawIcon = function() {
		var index = this._item.iconIndex;
		var iconSet = ImageManager.loadSystem('IconSet');
		var iw = Window_Base._iconWidth;
		var ih = Window_Base._iconHeight;
		var ix = index % 16 * iw;
		var iy = Math.floor(index/16) * ih;
		var rate = this.pictureRate(iw, ih);
		var dw = iw * rate;
		var dh = ih * rate;
		var dx = this.pictureWidth()/2 - dw/2;
		var dy = this.pictureHeight()/2 - dh/2;
		this.contents.blt(iconSet, ix, iy, iw, ih, dx, dy, dw, dh);
	}

})()