#!/usr/bin/env python3
##############################################################################
# Copyright (C) 2017, Xunta de Galicia for Consolidacion Software Abalar     #
# Project <software.libre@edu.xunta.es>                                      #
# Author: Alfonso Bilbao Velez <alfonso.bilbao.velez.sa@everis.com>          #
# Developed by EVERIS S.L.U.                                                 #
##############################################################################
"""Read Battery Status, es un script para evaluar el consumo de batteria de un
portatil, recoge los datos en un fichero, para poder comparar posteriormente
entre distintos modelos."""
# Modulos utilizados.
import subprocess
import time
import os
import sys

from time import sleep
from datetime import datetime

# Fecha de la prueba. 
fecha_prueba = (datetime.today()).strftime('%d_%m_%y')

# Hora de comienzo de la prueba.
t_inicial = datetime.now()

# Registro del estado de la bateria.
def estado_bateria():
    """
    Recoge el valor porcentual del estado de la bateria utilizando el comando
    "upower".
    """
    # Comando upower.
    comando = "upower -i $(upower -e | grep BAT) | grep --color=never -E \
    percentage|xargs|cut -d' ' -f2"

    info_bateria = subprocess.Popen(["/bin/bash", "-c", comando], stdout=subprocess.PIPE)
    return info_bateria.communicate()[0].decode("utf-8").replace("\n", "")


# Registro del estado del transformador. 
# Charging = Enchufado/Discharging = Desenchufado
def estado_transformador():
    """
    Recoge si se enchufa o desenchufa el transformador de corriente 
    utilizando el comando "acpi".
    """
    # Comando acpi.
    comando = "acpi | grep -e 'Battery' | awk {'print $3'}"

    info_corriente = subprocess.Popen(["/bin/bash", "-c", comando], stdout=subprocess.PIPE)
    return info_corriente.communicate()[0].decode("utf-8").replace(",", "")

# Registro del power_supply para tener una referencia 0 o 1.
def check_powersupply():
    """
    Recoge si la corriente esta conectada o desconectada. 
    Conectado = 1;
    Desconectado = 0;
    """
    # Folder comun.
    carpeta_comun = "/sys/class/power_supply/"
    # Encontrar path relativo.
    for root, dirs, files in os.walk(carpeta_comun):
        for elem in dirs:
            if not elem.startswith("BAT"):
                ruta = os.path.join (root, elem)
    path = ruta + "/"
    # Comando.
    comando = "cat %sonline" %path

    info_online = subprocess.Popen(["/bin/bash", "-c", comando], stdout=subprocess.PIPE)
    return info_online.communicate()[0].decode("utf-8")

# Lanzar VLC reproduciendo un video en loop y pantalla completa.
def reproducir_video():
    """
    Reproducir un video en vlc para generar una carga de trabajo al pc.
    """
     # Comando vlc.
    comando = "vlc --loop -f Big_Buck_Bunny-720p.mp4"

    reproducir = subprocess.Popen(["/bin/bash", "-c", comando])


# Usar Kdialog para reproducir los mensajes.
def imprimir_mensajes(mensaje):
    """Imprimir mensajes utilizando Kdialog"""
    subprocess.run(['kdialog', '--sorry', mensaje])


# Registrar los datos cuando el test ha comenzado.
def registrar_datos():
    """Registra los datos si se cumple con las condiciones preestablecidas."""
    # Creamos un fichero para almacenar la informacion.
    nombre_fichero = 'test_bateria_'+fecha_prueba+t_inicial.strftime('_%H-%M')+'.txt'
    f = open(str(nombre_fichero), 'a+')

    # Se crea una variable con valor 0, como una referencia neutra.
    contador = 0

    # Imprimir en pantalla para saber que el script se esta ejecutando.
    print("#############################")
    print("Data da proba: %s" %fecha_prueba)
    print("Inicio da proba: %s" %t_inicial.strftime('%H:%M:%S'))
    print("#############################\n")

    # Timestamp inicial al inicio de la prueba.
    f.write("#####################\n")
    f.write(" Data da proba:\n %s \n" \
            %t_inicial.strftime('%d-%m-%y'))
    f.write(" Hora da proba:\n %s \n" \
            %t_inicial.strftime('%H:%M:%S'))
    f.write("#####################\n")

    # Bucle para recoger la informacion.
    while True:
        # Abrir el fichero en cada iteracion.
        f = open(str(nombre_fichero), "a")
        # Sumar 1 a la variable neutral.
        contador +=1
        # Comprobar el porcentaje de bateria en cada iteracion.
        carga = str(estado_bateria())
        # Comprobar el estado del transformador en cada iteracion.
        corriente = str(estado_transformador())

        # Timestamp por cada iteracion.
        t_actual = datetime.now()
        # Calcular el tiempo transcurrido.
        t_transcurrido = t_actual - t_inicial
        # Esperar 60 segundos para cada lectura.
        sleep(60)

        # Imprimir en pantalla: contador, tiempo, porcentaje, estado.
        print("Minutos: %s" %contador)
        print("Tempo transcorrido: %s" %t_transcurrido)
        print("Porcentaxe da batería: %s" %carga)
        print("Estado da batería: %s" %corriente)
        print("")

        # Escribir una linea en el fichero por cada iteracion registrada.
        f.writelines("Minutos: %s \n" %contador  +\
                     "Tempo transcorrido: %s \n" %t_transcurrido +\
                     "Porcentaxe de batería: %s" %carga + '\n' +\
                     "Estado da batería: %s\n" %corriente + "\n")


# Realizar comprobaciones para poder empezar el test.
# En caso contrario mostrar una alerta.
def empezar_test():
    """Realiza las comprobaciones para poder empezar el test. En caso de no
    cumplirse, lanza un mensaje de alerta."""
    alerta = """
    Antes de  empezar a proba.\n
    Deberias desconectar o transformador de corrente.
    """
    info_online = int(check_powersupply())
    # Si el transformador esta conectado, imprimir alerta.
    if info_online == 1:
        imprimir_mensajes(alerta)
        empezar_test()
    # Si el transformador esta desconectado, reproducir video.
    elif info_online == 0:
        reproducir_video()

####################
# Funcion Principal#
####################
def main():
    try:
        empezar_test()
        registrar_datos()
    except:
        print("A proba terminó inesperadamente.")

if __name__== '__main__':
    main()
