/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Resources;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class NodeMotionListenerView
extends JComponent {
    private NodeView movedView;
    private boolean isMouseEntered;

    public NodeMotionListenerView(NodeView view) {
        this.movedView = view;
        MapView map = view.getMap();
        this.addMouseListener(map.getNodeMotionListener());
        this.addMouseMotionListener(map.getNodeMotionListener());
        this.setCursor(new Cursor(13));
        String helpMsg = Resources.getInstance().getResourceString("node_location_help");
        this.setToolTipText(helpMsg);
    }

    public NodeView getMovedView() {
        return this.movedView;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isMouseEntered()) {
            Graphics2D g2 = (Graphics2D)g;
            Color color = g2.getColor();
            if (this.movedView.getModel().getHGap() <= 0) {
                g2.setColor(Color.RED);
                g.fillOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            } else {
                g2.setColor(Color.BLACK);
                g.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g2.setColor(color);
        }
    }

    public boolean isMouseEntered() {
        return this.isMouseEntered;
    }

    public void setMouseEntered() {
        this.isMouseEntered = true;
        this.repaint();
    }

    public void setMouseExited() {
        this.isMouseEntered = false;
        this.repaint();
    }
}

