/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;

class ForkMainView
extends MainView {
    ForkMainView() {
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        MindMapNode model = nodeView.getModel();
        if (model == null) {
            return;
        }
        Object renderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.getController().setEdgesRenderingHint(g);
        this.paintSelected(g);
        this.paintDragOver(g);
        int edgeWidth = model.getEdge().getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        Color oldColor = g.getColor();
        g.setColor(model.getEdge().getColor());
        g.drawLine(0, this.getHeight() - edgeWidth / 2 - 1, this.getWidth(), this.getHeight() - edgeWidth / 2 - 1);
        g.setColor(oldColor);
        super.paint(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    void paintFoldingMark(Graphics2D g, Point p) {
        int zoomedFoldingSymbolHalfWidth = this.getZoomedFoldingSymbolHalfWidth();
        if (p.x == -1) {
            p.x -= 2 * zoomedFoldingSymbolHalfWidth;
        } else if (p.x == this.getWidth()) {
            p.x += 2 * zoomedFoldingSymbolHalfWidth;
        }
        super.paintFoldingMark(g, p);
    }

    protected int getMainViewWidthWithFoldingMark() {
        int width = this.getWidth();
        if (this.getNodeView().getModel().isFolded()) {
            width += this.getZoomedFoldingSymbolHalfWidth() * 2 + this.getZoomedFoldingSymbolHalfWidth();
        }
        return width;
    }

    protected int getMainViewHeightWithFoldingMark() {
        int height = this.getHeight();
        if (this.getNodeView().getModel().isFolded()) {
            height += this.getZoomedFoldingSymbolHalfWidth();
        }
        return height;
    }

    public int getDeltaX() {
        if (this.getNodeView().getModel().isFolded() && this.getNodeView().isLeft()) {
            return super.getDeltaX() + this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return super.getDeltaX();
    }

    String getStyle() {
        return "fork";
    }

    int getAlignment() {
        return -1;
    }

    Point getLeftPoint() {
        int edgeWidth = this.getNodeView().getModel().getEdge().getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        Point in = new Point(0, this.getHeight() - edgeWidth / 2 - 1);
        return in;
    }

    Point getCenterPoint() {
        Point in = new Point(this.getWidth() / 2, this.getHeight() / 2);
        return in;
    }

    Point getRightPoint() {
        int edgeWidth = this.getNodeView().getModel().getEdge().getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        Point in = new Point(this.getWidth() - 1, this.getHeight() - edgeWidth / 2 - 1);
        return in;
    }
}

