/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;

class BubbleMainView
extends MainView {
    private static final Stroke BOLD_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    static final Stroke DEF_STROKE = new BasicStroke();

    BubbleMainView() {
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width += this.getNodeView().getMap().getZoomed(5);
        return prefSize;
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        MindMapNode model = nodeView.getModel();
        if (model == null) {
            return;
        }
        Object renderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.getController().setEdgesRenderingHint(g);
        this.paintSelected(g);
        this.paintDragOver(g);
        g.setColor(model.getEdge().getColor());
        g.setStroke(DEF_STROKE);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
        super.paint(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    public void paintSelected(Graphics2D graphics) {
        super.paintSelected(graphics);
        if (this.getNodeView().useSelectionColors()) {
            graphics.setColor(MapView.standardSelectColor);
            graphics.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
        }
    }

    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
    }

    Point getLeftPoint() {
        Point in = new Point(0, this.getHeight() / 2);
        return in;
    }

    Point getCenterPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() / 2;
        return in;
    }

    Point getRightPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() - 1;
        return in;
    }

    protected int getMainViewWidthWithFoldingMark() {
        int width = this.getWidth();
        int dW = this.getZoomedFoldingSymbolHalfWidth() * 2;
        if (this.getNodeView().getModel().isFolded()) {
            width += dW;
        }
        return width + dW;
    }

    public int getDeltaX() {
        if (this.getNodeView().getModel().isFolded() && this.getNodeView().isLeft()) {
            return super.getDeltaX() + this.getZoomedFoldingSymbolHalfWidth() * 2;
        }
        return super.getDeltaX();
    }

    String getStyle() {
        return "bubble";
    }

    int getAlignment() {
        return 0;
    }

    public int getTextWidth() {
        return super.getTextWidth() + this.getNodeView().getMap().getZoomed(5);
    }

    public int getTextX() {
        return super.getTextX() + this.getNodeView().getMap().getZoomed(2);
    }
}

