/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.viewmodes;

import freemind.main.XMLElement;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.common.CommonNodeKeyListener;
import freemind.modes.common.CommonToggleFoldedAction;
import freemind.modes.common.actions.FindAction;
import freemind.modes.common.listeners.CommonMouseMotionManager;
import freemind.modes.common.listeners.CommonNodeMouseMotionListener;
import freemind.modes.viewmodes.CommonToggleChildrenFoldedAction;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class ViewControllerAdapter
extends ControllerAdapter {
    public CommonToggleFoldedAction toggleFolded = new CommonToggleFoldedAction(this);
    public CommonToggleChildrenFoldedAction toggleChildrenFolded = new CommonToggleChildrenFoldedAction(this);
    public FindAction find = new FindAction(this);
    public FindAction.FindNextAction findNext = new FindAction.FindNextAction(this, this.find);

    public ViewControllerAdapter(Mode mode) {
        super(mode);
    }

    public void doubleClick(MouseEvent e) {
    }

    public void plainClick(MouseEvent e) {
    }

    public boolean extendSelection(MouseEvent e) {
        NodeView newlySelectedNodeView = ((MainView)e.getComponent()).getNodeView();
        boolean extend = e.isControlDown();
        boolean range = e.isShiftDown();
        boolean branch = e.isAltGraphDown() || e.isAltDown();
        boolean retValue = false;
        if (extend || range || branch || !this.getView().isSelected(newlySelectedNodeView)) {
            if (!range) {
                if (extend) {
                    this.getView().toggleSelected(newlySelectedNodeView);
                } else {
                    this.select(newlySelectedNodeView);
                }
                retValue = true;
            } else {
                retValue = this.getView().selectContinuous(newlySelectedNodeView);
            }
            if (branch) {
                this.getView().selectBranch(newlySelectedNodeView, extend);
                retValue = true;
            }
        }
        if (retValue) {
            e.consume();
            String link = newlySelectedNodeView.getModel().getLink();
            link = link != null ? link : " ";
            this.getController().getFrame().out(link);
        }
        return retValue;
    }

    public void setFolded(MindMapNode node, boolean folded) {
        this._setFolded(node, folded);
    }

    public void startupController() {
        super.startupController();
        this.getController().getNodeMouseMotionListener().register(new CommonNodeMouseMotionListener(this));
        this.getController().getMapMouseMotionListener().register(new CommonMouseMotionManager(this));
        this.getController().getNodeKeyListener().register(new CommonNodeKeyListener(this, new CommonNodeKeyListener.EditHandler(){

            public void edit(KeyEvent e, boolean addNew, boolean editLong) {
            }
        }));
    }

    public void shutdownController() {
        super.shutdownController();
        this.getController().getNodeMouseMotionListener().deregister();
        this.getController().getMapMouseMotionListener().deregister();
        this.getController().getNodeKeyListener().deregister();
    }

    protected void setAllActions(boolean enabled) {
        super.setAllActions(enabled);
        this.find.setEnabled(enabled);
        this.findNext.setEnabled(enabled);
        this.toggleFolded.setEnabled(enabled);
        this.toggleChildrenFolded.setEnabled(enabled);
    }

    public XMLElement createXMLElement() {
        throw new IllegalArgumentException("createXMLElement is not defined for " + this.getClass().getName());
    }
}

