/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.listeners;

import freemind.controller.Controller;
import freemind.modes.ControllerAdapter;
import freemind.modes.mindmapmode.actions.MindMapActions;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.mindmapview.MapView;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;
import java.util.Set;

public class MindMapMouseWheelEventHandler
implements MouseWheelListener {
    private static int SCROLL_SKIPS = 8;
    private static final int HORIZONTAL_SCROLL_MASK = 29;
    private static final int ZOOM_MASK = 2;

    public MindMapMouseWheelEventHandler(ControllerAdapter controller) {
        Controller.addPropertyChangeListener(new FreemindPropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("wheel_velocity")) {
                    SCROLL_SKIPS = Integer.parseInt(newValue);
                }
            }
        });
        SCROLL_SKIPS = controller.getFrame().getIntProperty("wheel_velocity", 8);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        MapView mapView = (MapView)e.getSource();
        ControllerAdapter mController = (ControllerAdapter)mapView.getModel().getModeController();
        if (mController.isBlocked()) {
            return;
        }
        Set registeredMouseWheelEventHandler = mController.getRegisteredMouseWheelEventHandler();
        Iterator i = registeredMouseWheelEventHandler.iterator();
        while (i.hasNext()) {
            MindMapActions.MouseWheelEventHandler handler = (MindMapActions.MouseWheelEventHandler)i.next();
            boolean result = handler.handleMouseWheelEvent(e);
            if (!result) continue;
            return;
        }
        if ((e.getModifiers() & 2) != 0) {
            float newZoomFactor = 1.0f + Math.abs((float)e.getWheelRotation()) / 10.0f;
            if (e.getWheelRotation() < 0) {
                newZoomFactor = 1.0f / newZoomFactor;
            }
            float newZoom = ((MapView)e.getComponent()).getZoom() / newZoomFactor;
            newZoom = (float)Math.rint(newZoom * 1000.0f) / 1000.0f;
            mController.getController().setZoom(newZoom);
        } else if ((e.getModifiers() & 0x1D) != 0) {
            ((MapView)e.getComponent()).scrollBy(SCROLL_SKIPS * e.getWheelRotation(), 0);
        } else {
            ((MapView)e.getComponent()).scrollBy(0, SCROLL_SKIPS * e.getWheelRotation());
        }
    }
}

