/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.main.FreeMindMain;
import freemind.modes.ControllerAdapter;
import freemind.modes.LinkRegistryAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.ModeController;
import freemind.modes.browsemode.BrowseNodeModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.security.AccessControlException;

public class BrowseMapModel
extends MapAdapter {
    private URL url;
    private MindMapLinkRegistry linkRegistry;

    public BrowseMapModel(FreeMindMain frame, ModeController modeController) {
        this(null, frame, modeController);
    }

    public BrowseMapModel(BrowseNodeModel root, FreeMindMain frame, ModeController modeController) {
        super(frame, modeController);
        if (root != null) {
            this.setRoot(root);
        } else {
            this.setRoot(new BrowseNodeModel(this.getFrame().getResourceString("new_mindmap"), this.getFrame(), modeController.getMap()));
        }
        this.linkRegistry = new LinkRegistryAdapter();
    }

    public MindMapLinkRegistry getLinkRegistry() {
        return this.linkRegistry;
    }

    public String toString() {
        if (this.getURL() == null) {
            return null;
        }
        return this.getURL().toString();
    }

    public File getFile() {
        return null;
    }

    protected void setFile() {
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL v) {
        this.url = v;
    }

    public boolean save(File file) {
        return true;
    }

    public boolean isSaved() {
        return true;
    }

    public void load(URL url) throws IOException {
        this.setURL(url);
        BrowseNodeModel root = this.loadTree(url);
        if (root == null) {
            throw new IOException();
        }
        this.setRoot(root);
        ((ControllerAdapter)this.mModeController).invokeHooksRecursively(root, this);
    }

    BrowseNodeModel loadTree(URL url) {
        BrowseNodeModel root = null;
        InputStreamReader urlStreamReader = null;
        try {
            urlStreamReader = new InputStreamReader(url.openStream());
        }
        catch (AccessControlException ex) {
            this.getFrame().getController().errorMessage("Could not open URL " + url.toString() + ". Access Denied.");
            System.err.println(ex);
            return null;
        }
        catch (Exception ex) {
            this.getFrame().getController().errorMessage("Could not open URL " + url.toString() + ".");
            System.err.println(ex);
            return null;
        }
        try {
            root = (BrowseNodeModel)this.getModeController().createNodeTreeFromXml(urlStreamReader);
            urlStreamReader.close();
            return root;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
    }

    public void setLinkInclinationChanged() {
    }

    public void getXml(Writer fileout) throws IOException {
        throw new RuntimeException("Unimplemented method called.");
    }

    public void getFilteredXml(Writer fileout) throws IOException {
        throw new RuntimeException("Unimplemented method called.");
    }
}

