/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.extensions.PermanentNodeHook;
import freemind.extensions.PermanentNodeHookSubstituteUnknown;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.CloudAdapter;
import freemind.modes.EdgeAdapter;
import freemind.modes.HistoryInformation;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeTableLayoutModel;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class XMLElementAdapter
extends XMLElement {
    protected static Logger logger;
    private Object userObject = null;
    protected FreeMindMain frame;
    private NodeAdapter mapChild = null;
    private HashMap nodeAttributes = new HashMap();
    private String fontName;
    private int fontStyle = 0;
    private int fontSize = 0;
    private String iconName;
    protected Vector ArrowLinkAdapters;
    protected HashMap IDToTarget;
    public static final String XML_NODE_TEXT = "TEXT";
    public static final String XML_NODE = "node";
    public static final String XML_NODE_ATTRIBUTE = "attribute";
    public static final String XML_NODE_ATTRIBUTE_LAYOUT = "attribute_layout";
    public static final String XML_NODE_ATTRIBUTE_REGISTRY = "attribute_registry";
    public static final String XML_NODE_REGISTERED_ATTRIBUTE_NAME = "attribute_name";
    public static final String XML_NODE_REGISTERED_ATTRIBUTE_VALUE = "attribute_value";
    public static final String XML_NODE_CLASS = "AA_NODE_CLASS";
    public static final String XML_NODE_ADDITIONAL_INFO = "ADDITIONAL_INFO";
    public static final String XML_NODE_ENCRYPTED_CONTENT = "ENCRYPTED_CONTENT";
    public static final String XML_NODE_HISTORY_CREATED_AT = "CREATED";
    public static final String XML_NODE_HISTORY_LAST_MODIFIED_AT = "MODIFIED";
    public static final String XML_NODE_XHTML_TYPE_TAG = "TYPE";
    public static final String XML_NODE_XHTML_TYPE_NODE = "NODE";
    public static final String XML_NODE_XHTML_TYPE_NOTE = "NOTE";
    private String attributeName;
    private String attributeValue;
    private int attributeNameWidth = 75;
    private int attributeValueWidth = 75;
    protected final ModeController mModeController;

    public XMLElementAdapter(ModeController modeController) {
        this(modeController, new Vector(), new HashMap());
    }

    protected XMLElementAdapter(ModeController modeController, Vector ArrowLinkAdapters, HashMap IDToTarget) {
        this.mModeController = modeController;
        this.frame = modeController.getFrame();
        this.ArrowLinkAdapters = ArrowLinkAdapters;
        this.IDToTarget = IDToTarget;
        if (logger == null) {
            logger = this.frame.getLogger(this.getClass().getName());
        }
    }

    protected abstract XMLElement createAnotherElement();

    protected abstract NodeAdapter createNodeAdapter(FreeMindMain var1, String var2);

    protected abstract EdgeAdapter createEdgeAdapter(NodeAdapter var1, FreeMindMain var2);

    protected abstract CloudAdapter createCloudAdapter(NodeAdapter var1, FreeMindMain var2);

    protected abstract ArrowLinkAdapter createArrowLinkAdapter(NodeAdapter var1, NodeAdapter var2, FreeMindMain var3);

    protected abstract NodeAdapter createEncryptedNode(String var1);

    protected FreeMindMain getFrame() {
        return this.frame;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    protected void setUserObject(Object obj) {
        this.userObject = obj;
    }

    public NodeAdapter getMapChild() {
        return this.mapChild;
    }

    public void setName(String name) {
        super.setName(name);
        if (name.equals(XML_NODE)) {
            this.userObject = this.createNodeAdapter(this.frame, null);
            this.nodeAttributes.clear();
        } else {
            this.userObject = name.equals("edge") ? this.createEdgeAdapter(null, this.frame) : (name.equals("cloud") ? this.createCloudAdapter(null, this.frame) : (name.equals("arrowlink") ? this.createArrowLinkAdapter(null, null, this.frame) : (name.equals("font") ? null : (name.equals(XML_NODE_ATTRIBUTE) ? null : (name.equals(XML_NODE_ATTRIBUTE_LAYOUT) ? null : (name.equals("map") ? null : (name.equals(XML_NODE_ATTRIBUTE_REGISTRY) ? null : (name.equals(XML_NODE_REGISTERED_ATTRIBUTE_NAME) ? null : (name.equals(XML_NODE_REGISTERED_ATTRIBUTE_VALUE) ? null : (name.equals("icon") ? null : (name.equals("hook") ? new XMLElement() : new XMLElement())))))))))));
        }
    }

    public void addChild(XMLElement child) {
        if (this.getName().equals("map")) {
            this.mapChild = (NodeAdapter)child.getUserObject();
            return;
        }
        if (this.userObject instanceof XMLElement) {
            super.addChild(child);
            return;
        }
        if (this.userObject instanceof NodeAdapter) {
            NodeAdapter node = (NodeAdapter)this.userObject;
            if (child.getUserObject() instanceof NodeAdapter) {
                node.insert((NodeAdapter)child.getUserObject(), -1);
            } else if (child.getUserObject() instanceof EdgeAdapter) {
                EdgeAdapter edge = (EdgeAdapter)child.getUserObject();
                edge.setTarget(node);
                node.setEdge(edge);
            } else if (child.getUserObject() instanceof CloudAdapter) {
                CloudAdapter cloud = (CloudAdapter)child.getUserObject();
                cloud.setTarget(node);
                node.setCloud(cloud);
            } else if (child.getUserObject() instanceof ArrowLinkAdapter) {
                ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)child.getUserObject();
                arrowLink.setSource(node);
                this.ArrowLinkAdapters.add(arrowLink);
            } else if (child.getName().equals("font")) {
                node.setFont((Font)child.getUserObject());
            } else if (child.getName().equals(XML_NODE_ATTRIBUTE)) {
                node.createAttributeTableModel();
                node.getAttributes().addRowNoUndo((Attribute)child.getUserObject());
            } else if (child.getName().equals(XML_NODE_ATTRIBUTE_LAYOUT)) {
                node.createAttributeTableModel();
                AttributeTableLayoutModel layout = node.getAttributes().getLayout();
                layout.setColumnWidth(0, ((XMLElementAdapter)child).attributeNameWidth);
                layout.setColumnWidth(1, ((XMLElementAdapter)child).attributeValueWidth);
            } else if (child.getName().equals("icon")) {
                node.addIcon((MindIcon)child.getUserObject(), -1);
            } else if (child.getName().equals("richcontent")) {
                String xmlText = child.getContent();
                Object typeAttribute = child.getAttribute(XML_NODE_XHTML_TYPE_TAG);
                if (typeAttribute == null || XML_NODE_XHTML_TYPE_NODE.equals(typeAttribute)) {
                    logger.finest("Setting node html content to:" + xmlText);
                    node.setXmlText(xmlText);
                } else {
                    logger.finest("Setting note html content to:" + xmlText);
                    node.setXmlNoteText(xmlText);
                }
            } else if (child.getName().equals("hook")) {
                XMLElement xml = child;
                String loadName = (String)xml.getAttribute("NAME");
                PermanentNodeHook hook = null;
                try {
                    hook = (PermanentNodeHook)this.mModeController.getHookFactory().createNodeHook(loadName);
                    hook.setNode(node);
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    hook = new PermanentNodeHookSubstituteUnknown(loadName);
                }
                hook.loadFrom(xml);
                node.addHook(hook);
            }
            return;
        }
        if (child instanceof XMLElementAdapter && this.getName().equals(XML_NODE_REGISTERED_ATTRIBUTE_NAME) && child.getName().equals(XML_NODE_REGISTERED_ATTRIBUTE_VALUE)) {
            Attribute attribute = new Attribute(this.attributeName, ((XMLElementAdapter)child).attributeValue);
            AttributeRegistry r = this.getMap().getRegistry().getAttributes();
            r.registry(attribute);
        }
    }

    public void setAttribute(String name, Object value) {
        String sValue = value.toString();
        if (this.ignoreCase) {
            name = name.toUpperCase();
        }
        if (this.userObject instanceof XMLElement) {
            super.setAttribute(name, value);
            return;
        }
        if (this.userObject instanceof NodeAdapter) {
            NodeAdapter node = (NodeAdapter)this.userObject;
            this.userObject = this.setNodeAttribute(name, sValue, node);
            this.nodeAttributes.put(name, sValue);
            return;
        }
        if (this.userObject instanceof EdgeAdapter) {
            EdgeAdapter edge = (EdgeAdapter)this.userObject;
            if (name.equals("STYLE")) {
                edge.setStyle(sValue);
            } else if (name.equals("COLOR")) {
                edge.setColor(Tools.xmlToColor(sValue));
            } else if (name.equals("WIDTH")) {
                if (sValue.equals("thin")) {
                    edge.setWidth(0);
                } else {
                    edge.setWidth(Integer.parseInt(sValue));
                }
            }
            return;
        }
        if (this.userObject instanceof CloudAdapter) {
            CloudAdapter cloud = (CloudAdapter)this.userObject;
            if (name.equals("STYLE")) {
                cloud.setStyle(sValue);
            } else if (name.equals("COLOR")) {
                cloud.setColor(Tools.xmlToColor(sValue));
            } else if (name.equals("WIDTH")) {
                cloud.setWidth(Integer.parseInt(sValue));
            }
            return;
        }
        if (this.userObject instanceof ArrowLinkAdapter) {
            ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)this.userObject;
            if (name.equals("STYLE")) {
                arrowLink.setStyle(sValue);
            } else if (name.equals("ID")) {
                arrowLink.setUniqueID(sValue);
            } else if (name.equals("COLOR")) {
                arrowLink.setColor(Tools.xmlToColor(sValue));
            } else if (name.equals("DESTINATION")) {
                arrowLink.setDestinationLabel(sValue);
            } else if (name.equals("REFERENCETEXT")) {
                arrowLink.setReferenceText(sValue);
            } else if (name.equals("STARTINCLINATION")) {
                arrowLink.setStartInclination(Tools.xmlToPoint(sValue));
            } else if (name.equals("ENDINCLINATION")) {
                arrowLink.setEndInclination(Tools.xmlToPoint(sValue));
            } else if (name.equals("STARTARROW")) {
                arrowLink.setStartArrow(sValue);
            } else if (name.equals("ENDARROW")) {
                arrowLink.setEndArrow(sValue);
            } else if (name.equals("WIDTH")) {
                arrowLink.setWidth(Integer.parseInt(sValue));
            }
            return;
        }
        if (this.getName().equals("font")) {
            if (name.equals("SIZE")) {
                this.fontSize = Integer.parseInt(sValue);
            } else if (name.equals("NAME")) {
                this.fontName = sValue;
            } else if (sValue.equals("true")) {
                if (name.equals("BOLD")) {
                    ++this.fontStyle;
                } else if (name.equals("ITALIC")) {
                    this.fontStyle += 2;
                }
            }
        }
        if (this.getName().equals("icon")) {
            if (name.equals("BUILTIN")) {
                this.iconName = sValue;
            }
        } else if (this.getName().equals(XML_NODE_ATTRIBUTE)) {
            if (name.equals("NAME")) {
                this.attributeName = sValue;
            } else if (name.equals("VALUE")) {
                this.attributeValue = sValue;
            }
        } else if (this.getName().equals(XML_NODE_ATTRIBUTE_LAYOUT)) {
            if (name.equals("NAME_WIDTH")) {
                this.attributeNameWidth = Integer.parseInt(sValue);
            } else if (name.equals("VALUE_WIDTH")) {
                this.attributeValueWidth = Integer.parseInt(sValue);
            }
        } else if (this.getName().equals(XML_NODE_ATTRIBUTE_REGISTRY)) {
            if (name.equals("RESTRICTED")) {
                this.getMap().getRegistry().getAttributes().setRestricted(true);
            }
            if (name.equals("SHOW_ATTRIBUTES")) {
                this.mModeController.getController().setAttributeViewType(this.getMap(), sValue);
            }
            if (name.equals("FONT_SIZE")) {
                try {
                    int size = Integer.parseInt(sValue);
                    this.getMap().getRegistry().getAttributes().setFontSize(size);
                }
                catch (NumberFormatException ex) {}
            }
        } else if (this.getName().equals(XML_NODE_REGISTERED_ATTRIBUTE_NAME)) {
            if (name.equals("NAME")) {
                this.attributeName = sValue;
                this.getMap().getRegistry().getAttributes().registry(this.attributeName);
            } else {
                super.setAttribute(name, sValue);
            }
        } else if (this.getName().equals(XML_NODE_REGISTERED_ATTRIBUTE_VALUE) && name.equals("VALUE")) {
            this.attributeValue = sValue;
        }
    }

    private NodeAdapter setNodeAttribute(String name, String sValue, NodeAdapter node) {
        if (name.equals(XML_NODE_TEXT)) {
            logger.finest("Setting node text content to:" + sValue);
            node.setUserObject(sValue);
        } else if (name.equals(XML_NODE_ENCRYPTED_CONTENT)) {
            node = this.createEncryptedNode(sValue);
        } else if (name.equals(XML_NODE_HISTORY_CREATED_AT)) {
            if (node.getHistoryInformation() == null) {
                node.setHistoryInformation(new HistoryInformation());
            }
            node.getHistoryInformation().setCreatedAt(Tools.xmlToDate(sValue));
        } else if (name.equals(XML_NODE_HISTORY_LAST_MODIFIED_AT)) {
            if (node.getHistoryInformation() == null) {
                node.setHistoryInformation(new HistoryInformation());
            }
            node.getHistoryInformation().setLastModifiedAt(Tools.xmlToDate(sValue));
        } else if (name.equals("FOLDED")) {
            if (sValue.equals("true")) {
                node.setFolded(true);
            }
        } else if (name.equals("POSITION")) {
            node.setLeft(sValue.equals("left"));
        } else if (name.equals("COLOR")) {
            if (sValue.length() == 7) {
                node.setColor(Tools.xmlToColor(sValue));
            }
        } else if (name.equals("BACKGROUND_COLOR")) {
            if (sValue.length() == 7) {
                node.setBackgroundColor(Tools.xmlToColor(sValue));
            }
        } else if (name.equals("LINK")) {
            node.setLink(sValue);
        } else if (name.equals("STYLE")) {
            node.setStyle(sValue);
        } else if (name.equals("ID")) {
            this.IDToTarget.put(sValue, node);
        } else if (name.equals("VSHIFT")) {
            node.setShiftY(Integer.parseInt(sValue));
        } else if (name.equals("VGAP")) {
            node.setVGap(Integer.parseInt(sValue));
        } else if (name.equals("HGAP")) {
            node.setHGap(Integer.parseInt(sValue));
        }
        return node;
    }

    protected void copyAttributesToNode(NodeAdapter node) {
        Iterator i = this.nodeAttributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.setNodeAttribute(key, (String)this.nodeAttributes.get(key), node);
        }
    }

    protected void completeElement() {
        if (this.getName().equals(XML_NODE)) {
            if (this.mapChild == null) {
                this.mapChild = (NodeAdapter)this.userObject;
            }
            return;
        }
        if (this.getName().equals("font")) {
            this.userObject = this.frame.getController().getFontThroughMap(new Font(this.fontName, this.fontStyle, this.fontSize));
            return;
        }
        if (this.getName().equals("icon")) {
            this.userObject = MindIcon.factory(this.iconName);
            return;
        }
        if (this.getName().equals(XML_NODE_ATTRIBUTE)) {
            this.userObject = new Attribute(this.attributeName, this.attributeValue);
            return;
        }
        if (this.getName().equals(XML_NODE_REGISTERED_ATTRIBUTE_NAME)) {
            if (null != this.getAttribute("VISIBLE")) {
                this.getMap().getRegistry().getAttributes().getElement((Comparable)((Object)this.attributeName)).setVisibility(true);
            }
            if (null != this.getAttribute("RESTRICTED")) {
                this.getMap().getRegistry().getAttributes().getElement((Comparable)((Object)this.attributeName)).setRestriction(true);
            }
            return;
        }
    }

    public void processUnfinishedLinks(MindMapLinkRegistry registry) {
        this.setIDs(this.IDToTarget, registry);
        for (int i = 0; i < this.ArrowLinkAdapters.size(); ++i) {
            ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)this.ArrowLinkAdapters.get(i);
            String oldID = arrowLink.getDestinationLabel();
            NodeAdapter target = null;
            String newID = null;
            if (this.IDToTarget.containsKey(oldID)) {
                target = (NodeAdapter)this.IDToTarget.get(oldID);
                newID = registry.getLabel(target);
            } else if (registry.getTargetForID(oldID) != null) {
                target = (NodeAdapter)registry.getTargetForID(oldID);
                if (target == null) {
                    System.err.println("Cannot find the label " + oldID + " in the getMap(). The link " + arrowLink + " is not restored.");
                    continue;
                }
                newID = registry.getLabel(target);
                if (!newID.equals(oldID)) {
                    System.err.println("Servere internal error. Looked for id " + oldID + " but found " + newID + " in the node " + target + ".");
                    continue;
                }
            } else {
                System.err.println("Cannot find the label " + oldID + " in the getMap(). The link " + arrowLink + " is not restored.");
                continue;
            }
            arrowLink.setDestinationLabel(newID);
            arrowLink.setTarget(target);
            registry.registerLink(arrowLink);
        }
    }

    private void setIDs(HashMap IDToTarget, MindMapLinkRegistry registry) {
        Iterator i = IDToTarget.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            NodeAdapter target = (NodeAdapter)IDToTarget.get(key);
            String newId = registry.registerLinkTarget(target, key);
            Vector cuttedLinks = registry.getCuttedNode(key);
            for (int j = 0; j < cuttedLinks.size(); ++j) {
                ArrowLinkAdapter link = (ArrowLinkAdapter)cuttedLinks.get(j);
                link.setTarget(target);
                link.setDestinationLabel(newId);
                registry.registerLink(link);
            }
        }
    }

    protected MindMap getMap() {
        return this.mModeController.getMap();
    }
}

