/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.FreeMind;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;

public class FreeMindStarter {
    public static final String JAVA_VERSION = System.getProperty("java.version");

    public static void main(String[] args) {
        FreeMindStarter.checkJavaVersion();
        Properties defaultPreferences = FreeMindStarter.readDefaultPreferences();
        FreeMindStarter.createUserDirectory(defaultPreferences);
        Properties userPreferences = FreeMindStarter.readUsersPreferences(defaultPreferences);
        FreeMindStarter.setDefaultLocale(userPreferences);
        FreeMind.main(args, defaultPreferences, userPreferences, FreeMindStarter.getUserPreferencesFile(defaultPreferences));
    }

    private static void checkJavaVersion() {
        System.out.println("Checking Java Version...");
        if (JAVA_VERSION.compareTo("1.4.0") < 0) {
            String message = "Warning: FreeMind requires version Java 1.4.0 or higher (your version: " + System.getProperty("java.version") + ", installed in " + System.getProperty("java.home") + ").";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "FreeMind", 2);
            System.exit(1);
        }
    }

    private static void createUserDirectory(Properties pDefaultProperties) {
        File userPropertiesFolder = new File(FreeMindStarter.getFreeMindDirectory(pDefaultProperties));
        try {
            if (!userPropertiesFolder.exists()) {
                userPropertiesFolder.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot create folder for user properties and logging: '" + userPropertiesFolder.getAbsolutePath() + "'");
        }
    }

    private static void setDefaultLocale(Properties pProperties) {
        String lang = pProperties.getProperty("language");
        if (lang == null) {
            return;
        }
        Locale localeDef = null;
        switch (lang.length()) {
            case 2: {
                localeDef = new Locale(lang);
                break;
            }
            case 5: {
                localeDef = new Locale(lang.substring(0, 1), lang.substring(3, 4));
                break;
            }
            default: {
                return;
            }
        }
        Locale.setDefault(localeDef);
    }

    private static Properties readUsersPreferences(Properties defaultPreferences) {
        Properties auto = null;
        auto = new Properties(defaultPreferences);
        try {
            FileInputStream in = null;
            File autoPropertiesFile = FreeMindStarter.getUserPreferencesFile(defaultPreferences);
            in = new FileInputStream(autoPropertiesFile);
            auto.load(in);
            ((InputStream)in).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Panic! Error while loading default properties.");
        }
        return auto;
    }

    private static File getUserPreferencesFile(Properties defaultPreferences) {
        String freemindDirectory = FreeMindStarter.getFreeMindDirectory(defaultPreferences);
        File userPropertiesFolder = new File(freemindDirectory);
        File autoPropertiesFile = new File(userPropertiesFolder, defaultPreferences.getProperty("autoproperties"));
        return autoPropertiesFile;
    }

    private static String getFreeMindDirectory(Properties defaultPreferences) {
        return System.getProperty("user.home") + File.separator + defaultPreferences.getProperty("properties_folder");
    }

    private static Properties readDefaultPreferences() {
        String propsLoc = "freemind.properties";
        URL defaultPropsURL = ClassLoader.getSystemResource(propsLoc);
        Properties props = new Properties();
        try {
            InputStream in = null;
            in = defaultPropsURL.openStream();
            props.load(in);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Panic! Error while loading default properties.");
        }
        return props;
    }
}

