/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.FilterController;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.JCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class DisjunctConditions
implements Condition {
    static final String NAME = "disjunct_condition";
    private Object[] conditions;

    public DisjunctConditions(Object[] conditions) {
        this.conditions = conditions;
    }

    public boolean checkNode(Controller c, MindMapNode node) {
        for (int i = 0; i < this.conditions.length; ++i) {
            Condition cond = (Condition)this.conditions[i];
            if (!cond.checkNode(c, node)) continue;
            return true;
        }
        return false;
    }

    public JComponent getListCellRendererComponent() {
        JCondition component = new JCondition();
        component.add(new JLabel("("));
        Condition cond = (Condition)this.conditions[0];
        JComponent rendererComponent = cond.getListCellRendererComponent();
        rendererComponent.setOpaque(false);
        component.add(rendererComponent);
        for (int i = 1; i < this.conditions.length; ++i) {
            String text = ' ' + Resources.getInstance().getResourceString("filter_or") + ' ';
            component.add(new JLabel(text));
            cond = (Condition)this.conditions[i];
            rendererComponent = cond.getListCellRendererComponent();
            rendererComponent.setOpaque(false);
            component.add(rendererComponent);
        }
        component.add(new JLabel(")"));
        return component;
    }

    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        for (int i = 0; i < this.conditions.length; ++i) {
            Condition cond = (Condition)this.conditions[i];
            cond.save(child);
        }
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        Vector children = element.getChildren();
        Object[] conditions = new Object[children.size()];
        for (int i = 0; i < conditions.length; ++i) {
            Condition cond = FilterController.getConditionFactory().loadCondition((XMLElement)children.get(i));
            conditions[i] = cond;
        }
        return new DisjunctConditions(conditions);
    }
}

