/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.FilterController;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.JCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ConditionNotSatisfiedDecorator
implements Condition {
    static final String NAME = "negate_condition";
    private Condition originalCondition;

    public ConditionNotSatisfiedDecorator(Condition originalCondition) {
        this.originalCondition = originalCondition;
    }

    public boolean checkNode(Controller c, MindMapNode node) {
        return !this.originalCondition.checkNode(null, node);
    }

    public JComponent getListCellRendererComponent() {
        JCondition component = new JCondition();
        String text = Resources.getInstance().getResourceString("filter_not") + ' ';
        component.add(new JLabel(text));
        JComponent renderer = this.originalCondition.getListCellRendererComponent();
        renderer.setOpaque(false);
        component.add(renderer);
        return component;
    }

    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        this.originalCondition.save(child);
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        Vector children = element.getChildren();
        Condition cond = FilterController.getConditionFactory().loadCondition((XMLElement)children.get(0));
        return new ConditionNotSatisfiedDecorator(cond);
    }
}

