/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.IconInformation;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class MindIcon
implements Comparable,
IconInformation {
    public static final String PROPERTY_STRING_ICONS_LIST = "icons.list";
    private String name;
    private String description;
    private int number = -1;
    private ImageIcon associatedIcon;
    private static Vector mAllIconNames;
    private static ImageIcon iconNotFound;
    private static HashMap createdIcons;
    private static final int UNKNOWN = -1;
    public static final int LAST = -1;
    static int nextNumber;
    private JComponent component = null;

    private MindIcon(String name) {
        this.setName(name);
        this.associatedIcon = null;
    }

    private MindIcon(String name, ImageIcon icon) {
        this.setName(name);
        this.associatedIcon = icon;
    }

    public String toString() {
        return "Icon_name: " + this.name;
    }

    public String getName() {
        return this.name == null ? "notfound" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        String resource = new String("icon_" + this.getName());
        return Resources.getInstance().getResourceString(resource, resource);
    }

    public String getIconFileName() {
        return MindIcon.getIconsPath() + this.getIconBaseFileName();
    }

    public String getIconBaseFileName() {
        return this.getName() + ".png";
    }

    public static String getIconsPath() {
        return "images/icons/";
    }

    public ImageIcon getIcon() {
        if (iconNotFound == null) {
            iconNotFound = new ImageIcon(Resources.getInstance().getResource("images/IconNotFound.png"));
        }
        if (this.associatedIcon != null) {
            return this.associatedIcon;
        }
        if (this.name != null) {
            URL imageURL = Resources.getInstance().getResource(this.getIconFileName());
            if (imageURL == null) {
                try {
                    File file = new File(Resources.getInstance().getFreemindDirectory(), "icons/" + this.getName() + ".png");
                    if (file.canRead()) {
                        imageURL = Tools.fileToUrl(file);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ImageIcon icon = imageURL == null ? iconNotFound : new ImageIcon(imageURL);
            this.setIcon(icon);
            return icon;
        }
        this.setIcon(iconNotFound);
        return iconNotFound;
    }

    protected void setIcon(ImageIcon _associatedIcon) {
        this.associatedIcon = _associatedIcon;
    }

    public static Vector getAllIconNames() {
        if (mAllIconNames != null) {
            return mAllIconNames;
        }
        Vector<String> mAllIconNames = new Vector<String>();
        String icons = Resources.getInstance().getProperty(PROPERTY_STRING_ICONS_LIST);
        StringTokenizer tokenizer = new StringTokenizer(icons, ";");
        while (tokenizer.hasMoreTokens()) {
            mAllIconNames.add(tokenizer.nextToken());
        }
        return mAllIconNames;
    }

    public static MindIcon factory(String iconName) {
        if (createdIcons.containsKey(iconName)) {
            return (MindIcon)createdIcons.get(iconName);
        }
        MindIcon icon = new MindIcon(iconName);
        createdIcons.put(iconName, icon);
        return icon;
    }

    public static MindIcon factory(String iconName, ImageIcon icon) {
        if (createdIcons.containsKey(iconName)) {
            return (MindIcon)createdIcons.get(iconName);
        }
        MindIcon mindIcon = new MindIcon(iconName, icon);
        MindIcon.getAllIconNames().add(iconName);
        createdIcons.put(iconName, mindIcon);
        return mindIcon;
    }

    public int compareTo(Object o) {
        if (o instanceof MindIcon) {
            int i2;
            MindIcon icon = (MindIcon)o;
            int i1 = this.getNumber();
            return i1 < (i2 = icon.getNumber()) ? -1 : (i1 == i2 ? 0 : 1);
        }
        throw new ClassCastException();
    }

    private int getNumber() {
        if (this.number == -1) {
            this.number = MindIcon.getAllIconNames().indexOf(this.name);
        }
        if (this.number == -1) {
            this.number = nextNumber--;
        }
        return this.number;
    }

    public JComponent getRendererComponent() {
        if (this.component == null) {
            this.component = new JLabel(this.getIcon());
        }
        return this.component;
    }

    public String getKeystrokeResourceName() {
        return "keystroke_icon_" + this.name;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    static {
        createdIcons = new HashMap();
        nextNumber = -2;
    }
}

