/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.FixedHTMLWriter;
import freemind.main.Resources;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.Option;

public class XHTMLWriter
extends FixedHTMLWriter {
    private final MutableAttributeSet convAttr = new SimpleAttributeSet();
    private boolean writeLineSeparatorEnabled = true;

    public XHTMLWriter(Writer writer, HTMLDocument doc) {
        this(writer, doc, 0, doc.getLength());
    }

    public XHTMLWriter(Writer writer, HTMLDocument doc, int pos, int len) {
        super((Writer)new XHTMLFilterWriter(writer), doc, pos, len);
        this.setLineLength(Integer.MAX_VALUE);
    }

    public void write() throws IOException, BadLocationException {
        super.write();
    }

    protected void writeOption(Option option) throws IOException {
        this.writeLineSeparatorEnabled = false;
        super.writeOption(option);
        this.writeLineSeparatorEnabled = true;
        this.write("</option>");
        this.writeLineSeparator();
    }

    protected void writeLineSeparator() throws IOException {
        if (this.writeLineSeparatorEnabled) {
            super.writeLineSeparator();
        }
    }

    public static void html2xhtml(Reader reader, Writer writer) throws IOException, BadLocationException {
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = kit.createDefaultDocument();
        kit.read(reader, doc, doc.getLength());
        XHTMLWriter xhw = new XHTMLWriter(writer, (HTMLDocument)doc);
        xhw.write();
    }

    public static void main(String[] args) {
        try {
            FileReader reader = new FileReader(args[0]);
            FileWriter writer = new FileWriter(args[1]);
            XHTMLWriter.html2xhtml(reader, writer);
            writer.close();
            reader.close();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    public static class XHTMLFilterWriter
    extends FilterWriter {
        private boolean insideTag = false;
        private boolean insideValue = false;
        private boolean readTag = false;
        private String tag = "";

        public XHTMLFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(int c) throws IOException {
            if (this.insideValue) {
                if (c == 38) {
                    super.write("&amp;", 0, 5);
                    return;
                }
                if (c == 60) {
                    super.write("&lt;", 0, 4);
                    return;
                }
                if (c == 62) {
                    super.write("&gt;", 0, 4);
                    return;
                }
                if (c == 34) {
                    this.insideValue = false;
                }
            } else if (this.insideTag) {
                if (this.readTag) {
                    if (c == 32 || c == 62) {
                        this.readTag = false;
                    } else {
                        this.tag = this.tag + (char)c;
                    }
                }
                if (c == 34) {
                    this.insideValue = true;
                } else if (c == 62) {
                    if (this.tag.equals("img") || this.tag.equals("br") || this.tag.equals("hr") || this.tag.equals("input") || this.tag.equals("meta") || this.tag.equals("link") || this.tag.equals("area") || this.tag.equals("base") || this.tag.equals("basefont") || this.tag.equals("frame") || this.tag.equals("iframe") || this.tag.equals("col")) {
                        super.write(" /");
                    }
                    this.insideTag = false;
                    this.readTag = false;
                }
            } else if (c == 60) {
                this.tag = "";
                this.insideTag = true;
                this.readTag = true;
            }
            super.write(c);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }
}

