/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.CompareConditionAdapter;
import freemind.controller.filter.condition.Condition;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.NodeAttributeTableModel;

public class AttributeCompareCondition
extends CompareConditionAdapter {
    static final String COMPARATION_RESULT = "comparation_result";
    static final String ATTRIBUTE = "attribute";
    static final String NAME = "attribute_compare_condition";
    static final String SUCCEED = "succeed";
    private String attribute;
    private int comparationResult;
    private boolean succeed;

    public AttributeCompareCondition(String attribute, String value, boolean ignoreCase, int comparationResult, boolean succeed) {
        super(value, ignoreCase);
        this.attribute = attribute;
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    public boolean checkNode(Controller c, MindMapNode node) {
        NodeAttributeTableModel attributes = node.getAttributes();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            try {
                if (!attributes.getValueAt(i, 0).equals(this.attribute) || this.succeed != (this.compareTo(attributes.getValueAt(i, 1).toString()) == this.comparationResult)) continue;
                return true;
            }
            catch (NumberFormatException fne) {
                // empty catch block
            }
        }
        return false;
    }

    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        super.saveAttributes(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
        child.setIntAttribute(COMPARATION_RESULT, this.comparationResult);
        child.setAttribute(SUCCEED, Tools.BooleanToXml(this.succeed));
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        return new AttributeCompareCondition(element.getStringAttribute(ATTRIBUTE), element.getStringAttribute("value"), Tools.xmlToBoolean(element.getStringAttribute("ignore_case")), element.getIntAttribute(COMPARATION_RESULT), Tools.xmlToBoolean(element.getStringAttribute(SUCCEED)));
    }

    protected String createDesctiption() {
        return super.createDescription(this.attribute, this.comparationResult, this.succeed);
    }
}

